
//////////////////////////
//Created by LostSinner//
////////////////////////
using System;
using Server;
using Server.Engines.XmlSpawner2;

namespace Server.Items
{
	public class VampRing : GoldRing
	{
		public override int ArtifactRarity{ get{ return 66; } }

		private DateTime m_NextUse;
		
// 		[CommandProperty( AccessLevel.GameMaster )]
		public DateTime NextUse { get { return m_NextUse; } set { m_NextUse  = value; } }
		
		[Constructable]
		public VampRing()
		{
			Hue = 2410;
			LootType = LootType.Cursed;
			Name = "Draculas Embrace";
			Hue = 37;
			Attributes.WeaponDamage = 10;
			Attributes.ReflectPhysical = 5;
			Attributes.CastSpeed = 3;
			Attributes.CastRecovery = 2;
			Attributes.RegenStam = 2;
			Attributes.RegenMana = 2;
			Attributes.RegenHits = 3;
		}

		public VampRing( Serial serial ) : base( serial )
		{
		}
		
		public override void OnDoubleClick( Mobile from ) 
		{ 
			VampGloves gloves = from.FindItemOnLayer( Layer.Gloves ) as VampGloves;
			VampHelm helm = from.FindItemOnLayer( Layer.Helm ) as VampHelm;
			VampLegs legs = from.FindItemOnLayer( Layer.Pants ) as VampLegs;
			VampArms arms = from.FindItemOnLayer( Layer.Arms ) as VampArms;
			VampGorget gorget = from.FindItemOnLayer( Layer.Neck ) as VampGorget;
			VampEarrings earrings = from.FindItemOnLayer( Layer.Earrings ) as VampEarrings;
			VampRing ring = from.FindItemOnLayer( Layer.Ring ) as VampRing;
			VampBracelet bracelet = from.FindItemOnLayer( Layer.Bracelet ) as VampBracelet;
			
			if (XmlAttach.FindAttachment(from, typeof(VampireQuest)) == null)
				XmlAttach.AttachTo(from, new VampireQuest( m_NextUse ));
         
         VampireQuest qatt = (VampireQuest)XmlAttach.FindAttachment(from,typeof(VampireQuest));

         if ( Parent != from ) 
         { 
            from.SendMessage( "Prsten musí být nasazen abys mohl získat klíče" ); 
         }
			else if ( gloves == null || helm == null || legs == null  || arms == null || gorget == null || earrings == null || ring == null || bracelet == null)
			{
				from.SendMessage( "Pro získání klíčů musíš mít nasazeny všechny části brnění od Vladamira a Draculovi šperky!" );
			}
         else if ( qatt.NextRepeat < DateTime.Now )
         { 
				from.PlaySound( 0x220 );
				qatt.NextRepeat = DateTime.Now + TimeSpan.FromDays( 2.0 );
				from.AddToBackpack( new DracsKey() );
				from.AddToBackpack( new BookOfTheDammed() );
			}
			else
			{
				from.SendMessage( "Jeste nemuzes prsten znovu pouzit." );
			}
		}


		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 1 );
			writer.Write(m_NextUse);
		}
		
		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
			
			switch( version )
			{
				case 1:
				{
					m_NextUse = reader.ReadDateTime();
					goto case 0;
				}
            case 0:
				{
					break;
				}
			}
		}
	}
}